/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.signals.watch.action.invokers;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.signals.watch.action.handlers.ActionHandler;
import com.floragunn.signals.watch.action.invokers.ActionInvoker;
import com.floragunn.signals.watch.checks.Check;
import com.floragunn.signals.watch.init.WatchInitializationService;
import com.floragunn.signals.watch.severity.SeverityLevel;
import com.floragunn.signals.watch.severity.SeverityMapping;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ResolveAction
extends ActionInvoker {
    protected final SeverityLevel.Set resolvesSeverityLevels;

    public ResolveAction(String name, ActionHandler handler, SeverityLevel.Set resolvesSeverityLevels, List<Check> checks) {
        super(name, handler, checks, null, null);
        this.resolvesSeverityLevels = resolvesSeverityLevels;
    }

    public SeverityLevel.Set getResolvesSeverityLevels() {
        return this.resolvesSeverityLevels;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("type", this.handler.getType());
        if (this.name != null) {
            builder.field("name", this.name);
        }
        if (this.resolvesSeverityLevels != null) {
            builder.field("resolves_severity", (ToXContent)this.resolvesSeverityLevels);
        }
        if (this.checks != null && this.checks.size() > 0) {
            builder.field("checks").startArray();
            for (Check check : this.checks) {
                check.toXContent(builder, params);
            }
            builder.endArray();
        }
        this.handler.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public static ResolveAction create(WatchInitializationService watchInitService, DocNode jsonObject, SeverityMapping severityMapping) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vJsonNode = new ValidatingDocNode(jsonObject, validationErrors);
        String name = vJsonNode.get("name").required().asString();
        List<Check> checks = ResolveAction.createNestedChecks(watchInitService, vJsonNode, validationErrors);
        SeverityLevel.Set severityLevels = null;
        ActionHandler handler = null;
        try {
            severityLevels = SeverityLevel.Set.createWithNoneDisallowed(vJsonNode.get("resolves_severity").asAnything());
            ResolveAction.validateSeverityLevelsAgainstSeverityMapping(severityLevels, severityMapping);
        }
        catch (ConfigValidationException e) {
            validationErrors.add("resolves_severity", e);
        }
        try {
            handler = ActionHandler.create(watchInitService, vJsonNode);
        }
        catch (ConfigValidationException e) {
            validationErrors.add(null, e);
        }
        vJsonNode.checkForUnusedAttributes();
        validationErrors.throwExceptionForPresentErrors();
        return new ResolveAction(name, handler, severityLevels, checks);
    }

    public static List<ResolveAction> createFromArray(WatchInitializationService ctx, List<DocNode> arrayNode, SeverityMapping severityMapping) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ArrayList<ResolveAction> result = new ArrayList<ResolveAction>(arrayNode.size());
        for (DocNode member : arrayNode) {
            if (!member.isMap()) continue;
            try {
                result.add(ResolveAction.create(ctx, member, severityMapping));
            }
            catch (ConfigValidationException e) {
                validationErrors.add(member.hasNonNull("name") ? "[" + member.get("name") + "]" : "[]", e);
            }
        }
        validationErrors.throwExceptionForPresentErrors();
        return result;
    }

    private static void validateSeverityLevelsAgainstSeverityMapping(SeverityLevel.Set severityLevels, SeverityMapping severityMapping) throws ConfigValidationException {
        if (severityMapping == null) {
            throw new ConfigValidationException(new ValidationError(null, "A severity mapping is required to use resolve actions"));
        }
        if (severityLevels == null) {
            return;
        }
        Set<SeverityLevel> definedLevels = severityMapping.getDefinedLevels();
        if (!severityLevels.isSubsetOf(definedLevels)) {
            throw new ConfigValidationException(new ValidationError(null, "Uses a severity which is not defined by severity mapping: " + severityLevels.missingFromOther(definedLevels)));
        }
    }
}

